<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductVariationDetail extends Model 
{

    protected $table = 'product_variation_details';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('product_variation_id', 'variation_value_id');

    public function productVariation()
    {
        return $this->belongsTo('App\Models\ProductVariation');
    }

    public function variationValue()
    {
        return $this->belongsTo('App\Models\VariationValue');
    }

}